/*
 * Decompiled with CFR 0.152.
 */
package ags.ui.graphics;

import java.util.ArrayList;
import java.util.List;

public abstract class Palette {
    public int MATCH_TOLERANCE = 64;
    List colors = new ArrayList();
    public static int COLOR_DISTANCE_MAX = 49744125;

    public Palette() {
        this.initPalette();
    }

    protected abstract void initPalette();

    public int[] getColor(int col) {
        return (int[])this.colors.get(col);
    }

    public int getColorInt(int c) {
        int[] col = this.getColor(c);
        return 65536 * col[0] + 256 * col[1] + col[2];
    }

    public void addColor(int[] col) {
        this.colors.add(col);
    }

    public void addColor(int r, int g, int b) {
        int[] col = new int[]{r, g, b};
        this.addColor(col);
    }

    public int findColor(int color) {
        int[] col = this.parseIntColor(color);
        return this.findColor(col);
    }

    private int[] parseIntColor(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int[] col = new int[]{r, g, b};
        return col;
    }

    public int findColor(int[] color) {
        int lastDiff = COLOR_DISTANCE_MAX;
        int bestFit = 0;
        for (int i = 0; i < this.colors.size(); ++i) {
            int[] test = (int[])this.colors.get(i);
            int diff = (int)this.distance(color, test);
            if (diff >= lastDiff) continue;
            lastDiff = diff;
            bestFit = i;
        }
        return bestFit;
    }

    public double distance(int[] color, int[] test) {
        return Math.pow(Math.abs(color[0] - test[0]), 3.0) + Math.pow(Math.abs(color[1] - test[1]), 3.0) + Math.pow(Math.abs(color[2] - test[2]), 3.0);
    }
}

